package gui.menus.view;

import gui.*;
import gui.jtransitionsystem.*;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/**
 * @author Serafino and Andrea
 *
 */
public class TargetViewItem extends JMenuItem{

	
	static final long serialVersionUID = 1L;
	public TargetViewItem()
	{
		super();
		initialize();
	}
	
	private void initialize()
	{
		this.setText("Show Target");
		
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				showTarget();
			}
		});
	}
	
	public void showTarget()
	{
		if(GenericLoader.getTargetService()==null){
			JOptionPane.showMessageDialog(null, "Target Transition System not selected");
			return;
		}	

		if(GenericLoader.getTargetService().getAllStates().size() >=20)
		{
			int optionSelected = JOptionPane.showConfirmDialog(null, "The Target Graph size is "+ GenericLoader.getTargetService().getAllStates().size()+" nodes\n"+GenericLoader.getTargetService().getAllActions().size()+" edges\nVisualization could be very slow.\nAre you sure you want to visualize it anyway?", "Warning", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
			if(optionSelected == JOptionPane.YES_OPTION)
			{
				JTransitionSystemSimple jt = GenericLoader.getJTargetService();
				GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
				
				graphPanel.printGraph(jt.getVisualizationViewer());
				graphPanel.setGraphName(GenericLoader.getTargetServiceName());
				
			}
		}
		else
		{
			JTransitionSystemSimple jt = GenericLoader.getJTargetService();
			GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
			
			graphPanel.printGraph(jt.getVisualizationViewer());
			graphPanel.setGraphName(GenericLoader.getTargetServiceName());
			
		}
	}
	
	
}
